/** @format */

import coindImg from "@/../public/add-coin-icon.svg";
import { FirebaseNotification } from "@/components/partials/header/Notification";
import { Button } from "@/components/ui/Button";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { useAuthStore } from "@/providers/AuthStoreProviders";
import { useTranslations } from "@/providers/TranslationProviders";
import { AuthStore } from "@/stores/auth";
import { redirectUrl } from "@/utils/helper";
import { GearIcon, UserIcon } from "@phosphor-icons/react/dist/ssr";
import Image from "next/image";
import Link from "next/link";
import ImageLoader from "../../ui/ImageLoader";

const HeaderAuthMenu = () => {
  const { user, logout, appInfo } = useAuthStore((state: AuthStore) => state);
  const { tran } = useTranslations();

  return user ? (
    <div className="flex items-center justify-start gap-1 sm:gap-3">
      {appInfo && <FirebaseNotification appInfo={appInfo} />}
      <div className="bg-primary/5 border-primary/10 flex items-center justify-start gap-1 rounded-md border px-3 py-1 sm:gap-3 sm:px-4 sm:py-2.5">
        <Image
          src={coindImg}
          alt=""
          className="size-5 sm:size-6"
          height={24}
          width={24}
        />
        <div>
          <p className="flex items-center justify-start gap-1 font-medium sm:text-lg">
            {user.coins}
          </p>
        </div>
      </div>

      <div className="relative">
        <DropdownMenu>
          <DropdownMenuTrigger asChild className="focus-visible:outline-none">
            <button className="border-primary rounded-full border-2 p-0.5">
              <ImageLoader
                src={user?.avatar}
                user={user}
                alt=""
                className="size-8 rounded-full sm:size-10"
                height={32}
                width={32}
              />
            </button>
          </DropdownMenuTrigger>
          <DropdownMenuContent align="end">
            <DropdownMenuItem>
              <Link
                href="/dashboard/profile"
                className="flex items-center justify-start gap-2"
              >
                {" "}
                <UserIcon />
                <span className=" ">{tran("Profile")}</span>
              </Link>
            </DropdownMenuItem>

            <DropdownMenuItem>
              <button
                className="flex items-center justify-start gap-2"
                onClick={logout}
              >
                {" "}
                <GearIcon />
                <span className=" ">{tran("Logout")}</span>
              </button>
            </DropdownMenuItem>
          </DropdownMenuContent>
        </DropdownMenu>
      </div>
    </div>
  ) : (
    <div className="flex items-center justify-start gap-3 text-sm font-medium">
      <Button
        variant="secondary-outline"
        onClick={redirectUrl}
        className="max-sm:px-2 max-sm:py-1"
      >
        {tran("Sign In")}
      </Button>
      <Button href={"/sign-up"} className="max-sm:px-2 max-sm:py-1">
        {tran("Sign Up")}
      </Button>
    </div>
  );
};

export default HeaderAuthMenu;
