/** @format */
import Loader from "@/components/ui/Loader";
import { setPageMetaData } from "@/hooks/server/pageSeoSetup";
import { staticPaginationPageGenerator } from "@/utils";
import { Suspense } from "react";
import PageContent from "@/components/partials/PageContent";
import QuizDetails from "./Details";

type Params = Promise<{ quiz: string }>;

export async function generateStaticParams() {
  return staticPaginationPageGenerator({
    url: "/quizzes",
    paramKey: "quiz",
    exceptKey: "translation.slug",
  });
}

export async function generateMetadata({ params }: { params: Params }) {
  const { quiz } = await params;
  return await setPageMetaData({
    type: "quiz",
    slug: quiz,
  });
}

const DetailPage = () => {
  return (
    <div>
      <div className="pb-10">
        <Suspense fallback={<Loader />}>
          <QuizDetails />
        </Suspense>
      </div>
      <PageContent page={"quizzes"} />
    </div>
  );
};

export default DetailPage;
