/** @format */
import Loader from "@/components/ui/Loader";
import { setPageMetaData } from "@/hooks/server/pageSeoSetup";
import { staticPaginationPageGenerator } from "@/utils";
import { Suspense } from "react";
import PageContent from "@/components/partials/PageContent";
import Details from "./Details";

type Params = Promise<{ contest: string }>;
export async function generateStaticParams() {
  return staticPaginationPageGenerator({
    url: "/get-contests",
    paramKey: "contest",
    exceptKey: "translation.slug",
  });
}

export async function generateMetadata({ params }: { params: Params }) {
  const { contest } = await params;
  return await setPageMetaData({
    type: "contest",
    slug: contest,
  });
}

const DetailPage = async () => {
  return (
    <div>
      <div className="pb-10">
        <Suspense fallback={<Loader />}>
          <Details />
        </Suspense>
      </div>

      <PageContent page={"contests"} />
    </div>
  );
};

export default DetailPage;
