/** @format */

import ErrorBoundary from "@/components/HOC/ErrorBoundary";
import { Protected } from "@/components/HOC/Protected";
import Error from "@/components/ui/error";
import PageContent from "@/components/partials/PageContent";

export default function layout({ children }: { children: React.ReactNode }) {
  return (
    <ErrorBoundary fallback={<Error />}>
      <Protected>
        {children}

        <PageContent page={"dashboard"} />
      </Protected>
    </ErrorBoundary>
  );
}
