"use client";
import { useAuthStore } from "@/providers/AuthStoreProviders";
import { useTranslations } from "@/providers/TranslationProviders";
import { AppInfoType } from "@/types";
import { useSearchParams } from "next/navigation";

export default function AuthPageTitle({ title }: { title: string }) {
  const searchParams = useSearchParams();
  const { appInfo }: { appInfo: AppInfoType } = useAuthStore(
    (state: any) => state,
  );
  const email = searchParams?.get("email");
  const phone = searchParams?.get("phone");

  const { tran } = useTranslations();
  return (
    <>
      <h4 className="heading-4 pb-1 text-center">
        {tran(title + appInfo?.application_info?.company_info?.name)}
      </h4>
      <p className="pt-2 text-center">
        {email && (
          <span>
            {tran("Send OTP to email:")} {email}
          </span>
        )}
        {phone && (
          <span>
            {tran("Send OTP to phone:")} {phone}
          </span>
        )}
      </p>
    </>
  );
}
